var samplePageObj = {
  // 샘플 타이틀
  title: '멀티 레코드(학교위치)',
  subtitle: '하나의 데이터를 여러행으로 나눠서 볼 수 있는 기능에 대한 예제입니다.',
  // 샘플 설명
  desc: '일반적인 데이터 그리드는 하나의 데이터가 하나의 행으로 보여지는데 멀티 레코드 기능은 하나의 데이터를 여러 행으로 표현해서 많은 데이터를 한 번에 제공할 수 있는 기능입니다.<br/>인사 정보와 같은 복잡한 데이터를 한눈에 볼 수 있도록 하는 예제입니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 2,
      MultiRecord: 1,
      FitWidth: true
    },
    Cols: [
      // 첫번째 단위데이터행(DataRow)
      [
        {
          Header: 'No',
          Name: 'SEQ',
          Align: 'Center',
          Width: 72,
          RecordRowSpan: 4
        },
        {
          Header: '학교ID',
          Type: 'Text',
          Name: 'schoolID',
          Align: 'Center',
          Width: 115,
          RecordRowSpan: 4
        },
        {
          Header: '학교명',
          Type: 'Text',
          Name: 'schoolName',
          Width: 170,
          Align: 'Center',
          RecordColSpan: 2
        },
        { Header: '학교명' },
        {
          Header: '시도교육청명',
          Type: 'Text',
          Name: 'sidoName',
          Width: 140,
          Align: 'Center',
          RecordRowSpan: 2,
          DefaultValue: '서울특별시교육청'
        },
        {
          Header: '교육지원청명',
          Type: 'Text',
          Name: 'eduName',
          Width: 180,
          Align: 'Center',
          RecordRowSpan: 2,
          DefaultValue: '서울특별시동부교육지원청'
        },

        {
          Header: '위도',
          Type: 'Float',
          Name: 'latitudeData',
          Align: 'Center',
          Width: 100,
          Visible: 0,
          CanEmpty: 1,
          RecordRowSpan: 4,
          RecordHColSpan: 2,
          RecordHColTitle: '위치정보'
        },
        {
          Header: '경도',
          Type: 'Float',
          Name: 'longitudeData',
          Align: 'Center',
          Width: 100,
          Visible: 0,
          CanEmpty: 1,
          RecordRowSpan: 4
        }
      ],
      [
        { Header: 'No' },
        { Header: '학교ID' },
        {
          Header: '학교급구분',
          Type: 'Enum',
          Name: 'schoolKinds',
          Align: 'Center',
          Enum: '|초등학교|중학교|고등학교',
          EnumKeys: '|el|mi|hi'
        },
        {
          Header: '설립일자',
          Type: 'Date',
          Name: 'establishDate',
          Align: 'Center',
          Format: 'yyyy/MM/dd',
          DataFormat: 'yyyy/MM/dd',
          EditFormat: 'yyyy/MM/dd'
        },
        { Header: '시도교육청명' },
        { Header: '교육지원청명' },

        { Header: '위도' },
        { Header: '경도' }
      ],
      [
        { Header: 'No' },
        { Header: '학교ID' },
        {
          Header: '본교분교',
          Type: 'Enum',
          Name: 'schoolBranch',
          Align: 'Center',
          Enum: '|본교|분교',
          EnumKeys: '|A|B'
        },
        {
          Header: '설립형태',
          Type: 'Enum',
          Name: 'estabilshShape',
          Align: 'Center',
          Enum: '|공립|사립',
          EnumKeys: '|PS1|PS2'
        },
        {
          Header: '시도교육청코드',
          Type: 'Text',
          Name: 'sidoCode',
          Align: 'Center',
          RecordRowSpan: 2,
          DefaultValue: '7010000'
        },
        {
          Header: '교육지원청코드',
          Type: 'Text',
          Name: 'eduCode',
          Align: 'Center',
          RecordRowSpan: 2,
          DefaultValue: '7021000'
        },

        { Header: '위도' },
        { Header: '경도' }
      ],
      [
        { Header: 'No' },
        { Header: '학교ID' },
        {
          Header: '주소',
          Type: 'Text',
          Name: 'addName',
          Align: 'Center',
          RecordColSpan: 2
        },
        { Header: '주소' },
        { Header: '시도교육청코드' },
        { Header: '교육지원청코드' },

        { Header: '위도' },
        { Header: '경도' }
      ]
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {
  },

  // event구문
  event: {
  },

  // style 추가
  internalStyles: 'a{text-decoration:none;color:#4444FF;}',

  // data
  data: [
    {
      schoolID: 'B000001838',
      schoolName: '서울휘경초등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19590110',
      latitudeData: 37.5857358,
      longitudeData: 127.0581216,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 망우로6길 48',
    },
    {
      schoolID: 'B000001839',
      schoolName: '서울동답초등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19840123',
      latitudeData: 37.5718166,
      longitudeData: 127.0642055,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 답십리로60길 12',
    },
    {
      schoolID: 'B000001841',
      schoolName: '서울신답초등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19720509',
      latitudeData: 37.5730006,
      longitudeData: 127.0433994,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 천호대로 177',
    },
    {
      schoolID: 'B000001842',
      schoolName: '서울용두초등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19481101',
      latitudeData: 37.5757428,
      longitudeData: 127.0288848,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 천호대로13길 43',
    },
    {
      schoolID: 'B000001842',
      schoolName: '서울이문초등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19670906',
      latitudeData: 37.60204,
      longitudeData: 127.0641929,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 신이문로 16',
    },
    {
      schoolID: 'B000001843',
      schoolName: '서울군자초등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19731122',
      latitudeData: 37.5643015,
      longitudeData: 127.0613471,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 한천로6길 21',
    },
    {
      schoolID: 'B000001844',
      schoolName: '서울장평초등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19800404',
      latitudeData: 37.5738074,
      longitudeData: 127.0732688,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 답십리로69길 27',
    },
    {
      schoolID: 'B000001845',
      schoolName: '서울안평초등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19901010',
      latitudeData: 37.5657116,
      longitudeData: 127.0713495,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 장한로14길 61',
    },
    {
      schoolID: 'B000008085',
      schoolName: '숭인중학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'mi',
      establishDate: '19750301',
      latitudeData: 37.5737834,
      longitudeData: 127.0438537,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 천호대로47길 34',
    },
    {
      schoolID: 'B000008086',
      schoolName: '장평중학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'mi',
      establishDate: '19671020',
      latitudeData: 37.5665027,
      longitudeData: 127.0705294,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 답십리로72길 158',
    },
    {
      schoolID: 'B000008087',
      schoolName: '전일중학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'mi',
      establishDate: '19740304',
      latitudeData: 37.5819789,
      longitudeData: 127.0583551,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 동대문구 사가정로13길 67',
    },
    {
      schoolID: 'B000011289',
      schoolName: '경기상업고등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'hi',
      establishDate: '19230514',
      latitudeData: 37.5892588925,
      longitudeData: 126.9700589043,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 종로구 자하문로 136',
    },
    {
      schoolID: 'B000011290',
      schoolName: '서일국제경영고등학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'hi',
      establishDate: '19661208',
      latitudeData: 37.5793722,
      longitudeData: 127.0130226,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS2',
      sidoCode: '7010000',
      eduCode: '7021000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 종로구 지봉로17길 49',
    },
    {
      schoolID: 'B000002432',
      schoolName: '광일초등학교',
      sidoName: '부산광역시교육청',
      eduName: '부산광역시서부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19980901',
      latitudeData: 35.1037252,
      longitudeData: 129.029845,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7150000',
      eduCode: '7171000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '부산광역시 중구 중구로 74',
    },
    {
      schoolID: 'B000002433',
      schoolName: '보수초등학교',
      sidoName: '부산광역시교육청',
      eduName: '부산광역시서부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19530709',
      latitudeData: 35.1060704517,
      longitudeData: 129.024219,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7150000',
      eduCode: '7171000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '부산광역시 중구 흑교로 74',
    },
    {
      schoolID: 'B000002434',
      schoolName: '봉래초등학교',
      sidoName: '부산광역시교육청',
      eduName: '부산광역시서부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '18950501',
      latitudeData: 35.1114813,
      longitudeData: 129.0361247,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7150000',
      eduCode: '7171000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '부산광역시 중구 대영로226번길 15',
    },
    {
      schoolID: 'B000002435',
      schoolName: '남성초등학교',
      sidoName: '부산광역시교육청',
      eduName: '부산광역시서부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19650310',
      latitudeData: 35.1041108043,
      longitudeData: 129.0323863767,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS2',
      sidoCode: '7150000',
      eduCode: '7171000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '부산광역시 중구 샘길 14',
    },
    {
      schoolID: 'B000002733',
      schoolName: '대구종로초등학교',
      sidoName: '대구광역시교육청',
      eduName: '대구광역시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19001111',
      latitudeData: 35.8723862,
      longitudeData: 128.5901329,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7240000',
      eduCode: '7251000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '대구광역시 중구 경상감영길 49',
    },
    {
      schoolID: 'B000002734',
      schoolName: '대구수창초등학교',
      sidoName: '대구광역시교육청',
      eduName: '대구광역시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19070713',
      latitudeData: 35.8742917,
      longitudeData: 128.5841371,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7240000',
      eduCode: '7251000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '대구광역시 중구 달성로22길 30',
    },
    {
      schoolID: 'B000002735',
      schoolName: '대구동덕초등학교',
      sidoName: '대구광역시교육청',
      eduName: '대구광역시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19560329',
      latitudeData: 35.8647633,
      longitudeData: 128.6046765,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7240000',
      eduCode: '7251000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '대구광역시 중구 동덕로26길 20',
    },
    {
      schoolID: 'B000002736',
      schoolName: '대구삼덕초등학교',
      sidoName: '대구광역시교육청',
      eduName: '대구광역시동부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19380406',
      latitudeData: 35.8635879,
      longitudeData: 128.6081317,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7240000',
      eduCode: '7251000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '대구광역시 중구 달구벌대로447길 10',
    },
    {
      schoolID: 'B000027297',
      schoolName: '세인트존스베리 아카데미 제주',
      sidoName: '제주특별자치도교육청',
      eduName: '제주특별자치도서귀포시교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'hi',
      establishDate: '20171023',
      latitudeData: 33.2833041268,
      longitudeData: 126.281407946,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS2',
      sidoCode: '9290000',
      eduCode: '9299000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '제주특별자치도 서귀포시 대정읍 글로벌에듀로 304번길 9',
    },
    {
      schoolID: 'B000027368',
      schoolName: '도당중학교',
      sidoName: '경기도교육청',
      eduName: '경기도부천교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'mi',
      establishDate: '20180301',
      latitudeData: 37.5168287,
      longitudeData: 126.7865463,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7530000',
      eduCode: '7581000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '경기도 부천시 부천로366번길 19',
    },
    {
      schoolID: 'B000027390',
      schoolName: '평택서재초등학교',
      sidoName: '경기도교육청',
      eduName: '경기도평택교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '20181101',
      latitudeData: 37.0183484,
      longitudeData: 127.1036556,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7530000',
      eduCode: '7631000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '경기도 평택시 상서재로6길 19',
    },
    {
      schoolID: 'B000027396',
      schoolName: '평택새빛초등학교',
      sidoName: '경기도교육청',
      eduName: '경기도평택교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '20190901',
      latitudeData: 37.0249221,
      longitudeData: 127.1051136,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7530000',
      eduCode: '7631000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '경기도 평택시 신촌2로 33(칠원동)',
    },
    {
      schoolID: 'B000027418',
      schoolName: '마장초등학교',
      sidoName: '경기도교육청',
      eduName: '경기도이천교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '19201204',
      latitudeData: 37.2464968,
      longitudeData: 127.3584748,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7530000',
      eduCode: '7741000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '경기도 이천시 마장면 오천로 130',
    },
    {
      schoolID: 'B000027505',
      schoolName: '인천중산초등학교',
      sidoName: '인천광역시교육청',
      eduName: '인천광역시남부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'el',
      establishDate: '20190301',
      latitudeData: 37.4946945,
      longitudeData: 126.5655989,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7310000',
      eduCode: '7321000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '인천광역시 중구 두미포로 100',
    },
    {
      schoolID: 'B000027506',
      schoolName: '인천중산중학교',
      sidoName: '인천광역시교육청',
      eduName: '인천광역시남부교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'mi',
      establishDate: '20190301',
      latitudeData: 37.4982224,
      longitudeData: 126.571277,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7310000',
      eduCode: '7321000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '인천광역시 중구 두미포로 189',
    },
    {
      schoolID: 'B000027509',
      schoolName: '해누리중학교',
      sidoName: '서울특별시교육청',
      eduName: '서울특별시강동송파교육지원청',
      agencyName: '한국교원대학교',
      schoolKinds: 'mi',
      establishDate: '20190301',
      latitudeData: 37.4976117755,
      longitudeData: 127.1025328181,
      agencyCode: '7001220',
      dataData: '20190116',
      checks: '0',
      schoolBranch: 'A',
      estabilshShape: 'PS1',
      sidoCode: '7010000',
      eduCode: '7071000',
      createDate: '20131129',
      changeDate: '20190110',
      addName: '서울특별시 송파구 송파대로37길 95',
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
